<?php
require_once "../config/db.php";
include "header.php";

$message = "";

// Handle create/update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int)($_POST['id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    $category_id = (int)($_POST['category_id'] ?? 0);
    $price = (float)($_POST['price_per_unit'] ?? 0);
    $unit = trim($_POST['unit'] ?? 'kg');
    $stock = (int)($_POST['stock_quantity'] ?? 0);
    $short_description = trim($_POST['short_description'] ?? '');
    $is_active = isset($_POST['is_active']) ? 1 : 0;

    $image_name = $_POST['existing_image'] ?? '';

    if (!empty($_FILES['image']['name'])) {
        $uploadDir = "../public/uploads/";
        if (!is_dir($uploadDir)) { mkdir($uploadDir, 0777, true); }
        $image_name = time() . "_" . basename($_FILES['image']['name']);
        move_uploaded_file($_FILES['image']['tmp_name'], $uploadDir . $image_name);
    }

    if ($id > 0) {
        $stmt = $conn->prepare("UPDATE fruits SET name=?, category_id=?, price_per_unit=?, unit=?, stock_quantity=?, short_description=?, image=?, is_active=? WHERE id=?");
        $stmt->bind_param("sidsissii", $name, $category_id, $price, $unit, $stock, $short_description, $image_name, $is_active, $id);
        $stmt->execute();
        $message = "Fruit updated successfully.";
    } else {
        $stmt = $conn->prepare("INSERT INTO fruits (name, category_id, price_per_unit, unit, stock_quantity, short_description, image, is_active) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sidsissi", $name, $category_id, $price, $unit, $stock, $short_description, $image_name, $is_active);
        $stmt->execute();
        $message = "Fruit created successfully.";
    }
}

// Activate/deactivate
if (isset($_GET['toggle'])) {
    $id = (int)$_GET['toggle'];
    $conn->query("UPDATE fruits SET is_active = 1 - is_active WHERE id = $id");
}

// Delete (optional)
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $conn->query("DELETE FROM fruits WHERE id = $id");
}

// For edit form
$editFruit = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $res = $conn->query("SELECT * FROM fruits WHERE id = $id");
    $editFruit = $res->fetch_assoc();
}

// Categories for dropdown
$categories = $conn->query("SELECT id, name FROM categories ORDER BY name");

// Fruits list
$search = trim($_GET['q'] ?? '');
$catFilter = (int)($_GET['category'] ?? 0);
$sql = "SELECT f.*, c.name AS category_name FROM fruits f 
        LEFT JOIN categories c ON f.category_id = c.id WHERE 1=1";
if ($search !== "") {
    $sql .= " AND f.name LIKE '%" . $conn->real_escape_string($search) . "%'";
}
if ($catFilter > 0) {
    $sql .= " AND f.category_id = " . $catFilter;
}
$sql .= " ORDER BY f.name";
$fruits = $conn->query($sql);
?>
<div class="table-card">
    <h2>Fruit Products</h2>
    <?php if($message): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data" style="margin-bottom:20px; display:grid; grid-template-columns: repeat(2, minmax(0,1fr)); gap:16px;">
        <input type="hidden" name="id" value="<?php echo $editFruit['id'] ?? ''; ?>">
        <input type="hidden" name="existing_image" value="<?php echo $editFruit['image'] ?? ''; ?>">
        <div>
            <div class="form-group">
                <label>Fruit Name</label>
                <input type="text" name="name" value="<?php echo htmlspecialchars($editFruit['name'] ?? ''); ?>" required>
            </div>
            <div class="form-group">
                <label>Category</label>
                <select name="category_id" required>
                    <option value="">Select category</option>
                    <?php
                    $categories->data_seek(0);
                    while ($cat = $categories->fetch_assoc()):
                    ?>
                        <option value="<?php echo $cat['id']; ?>" <?php if(($editFruit['category_id'] ?? 0) == $cat['id']) echo 'selected'; ?>>
                            <?php echo htmlspecialchars($cat['name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            <div class="form-group">
                <label>Price per unit</label>
                <input type="number" step="0.01" name="price_per_unit" value="<?php echo htmlspecialchars($editFruit['price_per_unit'] ?? ''); ?>" required>
            </div>
            <div class="form-group">
                <label>Unit (e.g., kg, dozen)</label>
                <input type="text" name="unit" value="<?php echo htmlspecialchars($editFruit['unit'] ?? 'kg'); ?>" required>
            </div>
        </div>
        <div>
            <div class="form-group">
                <label>Stock quantity</label>
                <input type="number" name="stock_quantity" value="<?php echo htmlspecialchars($editFruit['stock_quantity'] ?? '0'); ?>">
            </div>
            <div class="form-group">
                <label>Short description</label>
                <textarea name="short_description" rows="3"><?php echo htmlspecialchars($editFruit['short_description'] ?? ''); ?></textarea>
            </div>
            <div class="form-group">
                <label>Image</label>
                <input type="file" name="image">
                <?php if(!empty($editFruit['image'])): ?>
                    <p>Current: <?php echo htmlspecialchars($editFruit['image']); ?></p>
                <?php endif; ?>
            </div>
            <div class="form-group">
                <label><input type="checkbox" name="is_active" <?php if(($editFruit['is_active'] ?? 1) == 1) echo 'checked'; ?>> Active</label>
            </div>
            <button type="submit" class="btn"><?php echo $editFruit ? 'Update Fruit' : 'Add Fruit'; ?></button>
        </div>
    </form>

    <form method="get" style="margin-bottom:16px; display:flex; gap:10px;">
        <input type="text" name="q" placeholder="Search fruits..." value="<?php echo htmlspecialchars($search); ?>">
        <select name="category">
            <option value="0">All categories</option>
            <?php
            $categories->data_seek(0);
            while ($cat = $categories->fetch_assoc()):
            ?>
                <option value="<?php echo $cat['id']; ?>" <?php if($catFilter == $cat['id']) echo 'selected'; ?>>
                    <?php echo htmlspecialchars($cat['name']); ?>
                </option>
            <?php endwhile; ?>
        </select>
        <button type="submit" class="btn">Filter</button>
    </form>

    <table class="table">
        <thead>
            <tr>
                <th>#</th>
                <th>Fruit</th>
                <th>Category</th>
                <th>Price</th>
                <th>Unit</th>
                <th>Stock</th>
                <th>Status</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php while ($fruit = $fruits->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $fruit['id']; ?></td>
                    <td><?php echo htmlspecialchars($fruit['name']); ?></td>
                    <td><?php echo htmlspecialchars($fruit['category_name']); ?></td>
                    <td>₹<?php echo number_format($fruit['price_per_unit'], 2); ?></td>
                    <td><?php echo htmlspecialchars($fruit['unit']); ?></td>
                    <td><?php echo (int)$fruit['stock_quantity']; ?></td>
                    <td><?php echo $fruit['is_active'] ? 'Active' : 'Inactive'; ?></td>
                    <td>
                        <a href="?edit=<?php echo $fruit['id']; ?>">Edit</a> |
                        <a href="?toggle=<?php echo $fruit['id']; ?>">Toggle</a> |
                        <a href="?delete=<?php echo $fruit['id']; ?>" onclick="return confirm('Delete this fruit?')">Delete</a>
                    </td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
<?php include "footer.php"; ?>
