<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// calculate cart count for header (works for guests + logged-in users)
$cartCount = 0;
if (!empty($_SESSION['cart']) && is_array($_SESSION['cart'])) {
    foreach ($_SESSION['cart'] as $item) {
        $qty = isset($item['qty']) ? (int)$item['qty'] : 0;
        $cartCount += $qty;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Online Fruit Order</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
<header class="top-header">
    <div class="logo">
        <a href="index.php">FruitBasket<span>.</span></a>
    </div>
    <nav class="main-nav">
        <a href="index.php">Home</a>
        <a href="fruits.php">Shop Fruits</a>

        <!-- Cart is always visible, even if user is not logged in -->
        <a href="cart.php">Cart (<?php echo $cartCount; ?>)</a>

        <?php if(isset($_SESSION['user_id'])): ?>
            <a href="orders.php">My Orders</a>
            <a href="profile.php">Profile</a>
            <a href="logout.php" class="btn btn-outline">Logout</a>
        <?php else: ?>
            <a href="login.php">Login</a>
            <a href="register.php" class="btn">Sign Up</a>
        <?php endif; ?>
    </nav>
</header>
<main class="page-wrapper">
