<?php
require_once "../config/db.php";
require_once "../includes/auth.php";
require_once "../includes/cart_functions.php";

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_to_cart'])) {
    $fruit_id = (int)$_POST['fruit_id'];
    $name = $_POST['name'];
    $price = (float)$_POST['price'];
    addToCart($fruit_id, $name, $price);
    $message = "Added to cart.";
}

$stmt = $conn->prepare("SELECT f.*, c.name AS category_name FROM fruits f 
                        LEFT JOIN categories c ON f.category_id = c.id 
                        WHERE f.id = ? AND f.is_active = 1");
$stmt->bind_param("i", $id);
$stmt->execute();
$fruit = $stmt->get_result()->fetch_assoc();

include "../includes/header.php";
?>

<?php if(!$fruit): ?>
    <p>Fruit not found.</p>
<?php else: ?>
    <div class="table-card">
        <?php if($message): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
        <?php endif; ?>
        <div style="display:grid; grid-template-columns: 1.2fr 2fr; gap:24px;">
            <div>
                <img src="uploads/<?php echo htmlspecialchars($fruit['image']); ?>" alt="<?php echo htmlspecialchars($fruit['name']); ?>" style="width:100%; border-radius:12px;">
            </div>
            <div>
                <h2><?php echo htmlspecialchars($fruit['name']); ?></h2>
                <p style="color:#6b7280; margin:8px 0;"><?php echo nl2br(htmlspecialchars($fruit['short_description'])); ?></p>
                <p><strong>Category:</strong> <?php echo htmlspecialchars($fruit['category_name']); ?></p>
                <p><strong>Price:</strong> ₹<?php echo number_format($fruit['price_per_unit'], 2); ?> / <?php echo htmlspecialchars($fruit['unit']); ?></p>
                <?php if($fruit['stock_quantity'] !== null): ?>
                    <p><strong>Available stock:</strong> <?php echo (int)$fruit['stock_quantity']; ?></p>
                <?php endif; ?>
                <form method="post" style="margin-top:16px;">
                    <input type="hidden" name="fruit_id" value="<?php echo $fruit['id']; ?>"/>
                    <input type="hidden" name="name" value="<?php echo htmlspecialchars($fruit['name']); ?>"/>
                    <input type="hidden" name="price" value="<?php echo $fruit['price_per_unit']; ?>"/>
                    <button type="submit" name="add_to_cart" class="btn">Add to Cart</button>
                </form>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php include "../includes/footer.php"; ?>
