<?php
require_once "../config/db.php";
require_once "../includes/auth.php";
include "../includes/header.php";

$category_id = isset($_GET['category']) ? (int)$_GET['category'] : 0;
$search = trim($_GET['q'] ?? '');

// Fetch categories
$categories = [];
$catResult = $conn->query("SELECT id, name FROM categories ORDER BY name");
if ($catResult) {
    while ($row = $catResult->fetch_assoc()) {
        $categories[] = $row;
    }
}

// Build query
$sql = "SELECT f.*, c.name AS category_name FROM fruits f 
        LEFT JOIN categories c ON f.category_id = c.id 
        WHERE f.is_active = 1";
$params = [];
$types = "";

if ($category_id > 0) {
    $sql .= " AND f.category_id = ?";
    $types .= "i";
    $params[] = $category_id;
}
if ($search !== "") {
    $sql .= " AND f.name LIKE ?";
    $types .= "s";
    $params[] = "%" . $search . "%";
}
$sql .= " ORDER BY f.name";

$stmt = $conn->prepare($sql);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
?>
<div class="section-title">
    <h2>Shop Fruits</h2>
    <span>Filter by category or search</span>
</div>
<form method="get" style="margin-bottom:16px; display:flex; gap:10px; flex-wrap:wrap;">
    <select name="category">
        <option value="0">All categories</option>
        <?php foreach($categories as $cat): ?>
            <option value="<?php echo $cat['id']; ?>" <?php if($category_id == $cat['id']) echo 'selected'; ?>>
                <?php echo htmlspecialchars($cat['name']); ?>
            </option>
        <?php endforeach; ?>
    </select>
    <input type="text" name="q" placeholder="Search fruits..." value="<?php echo htmlspecialchars($search); ?>"/>
    <button type="submit" class="btn">Apply</button>
</form>

<div class="grid">
    <?php while ($fruit = $result->fetch_assoc()): ?>
        <div class="card">
            <img src="uploads/<?php echo htmlspecialchars($fruit['image']); ?>" alt="<?php echo htmlspecialchars($fruit['name']); ?>">
            <h3><?php echo htmlspecialchars($fruit['name']); ?></h3>
            <p><?php echo htmlspecialchars(substr($fruit['short_description'], 0, 60)); ?>...</p>
            <div class="card-price">₹<?php echo number_format($fruit['price_per_unit'], 2); ?> / <?php echo htmlspecialchars($fruit['unit']); ?></div>
            <div class="card-footer">
                <a href="fruit_details.php?id=<?php echo $fruit['id']; ?>" class="btn">Details</a>
                <span class="badge"><?php echo htmlspecialchars($fruit['category_name']); ?></span>
            </div>
        </div>
    <?php endwhile; ?>
</div>
<?php include "../includes/footer.php"; ?>
