<?php
require_once "../config/db.php";
require_once "../includes/auth.php";
include "../includes/header.php";

// Fetch some featured fruits
$fruits = [];
$sql = "SELECT f.*, c.name AS category_name FROM fruits f 
        LEFT JOIN categories c ON f.category_id = c.id 
        WHERE f.is_active = 1 
        ORDER BY f.id DESC LIMIT 8";
$result = $conn->query($sql);
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $fruits[] = $row;
    }
}
?>
<section class="hero">
    <div class="hero-text">
        <div class="hero-badge">Fresh • Seasonal • Delivered Daily</div>
        <h1>Order Fresh Fruits Online in Minutes</h1>
        <p>Skip the market queue. Get handpicked fruits sourced directly from trusted farms, delivered to your doorstep with care.</p>
        <div class="hero-cta">
            <a href="fruits.php" class="btn">Shop Fruits</a>
            <a href="#how-it-works">How it works</a>
        </div>
        <div class="hero-highlight">
            <span>✔ Same-day delivery on orders before 5 PM</span>
        </div>
    </div>
    <div class="hero-image">
        <!-- Decorative only -->
        <h2>🍎 🍊 🍇 🍌</h2>
    </div>
</section>

<section id="featured">
    <div class="section-title">
        <h2>Featured Fruits</h2>
        <span>Handpicked bestsellers for you</span>
    </div>
    <div class="grid">
        <?php foreach($fruits as $fruit): ?>
            <div class="card">
                <img src="uploads/<?php echo htmlspecialchars($fruit['image']); ?>" alt="<?php echo htmlspecialchars($fruit['name']); ?>">
                <h3><?php echo htmlspecialchars($fruit['name']); ?></h3>
                <p><?php echo htmlspecialchars(substr($fruit['short_description'], 0, 60)); ?>...</p>
                <div class="card-price">₹<?php echo number_format($fruit['price_per_unit'], 2); ?> / <?php echo htmlspecialchars($fruit['unit']); ?></div>
                <div class="card-footer">
                    <a href="fruit_details.php?id=<?php echo $fruit['id']; ?>" class="btn">View</a>
                    <span class="badge"><?php echo htmlspecialchars($fruit['category_name']); ?></span>
                </div>
            </div>
        <?php endforeach; ?>
        <?php if(empty($fruits)): ?>
            <p>No fruits available yet. Please check back later.</p>
        <?php endif; ?>
    </div>
</section>

<section id="how-it-works" style="margin-top:32px;">
    <div class="section-title">
        <h2>How It Works</h2>
        <span>Simple 3-step ordering</span>
    </div>
    <div class="grid">
        <div class="card">
            <h3>1. Browse Fruits</h3>
            <p>Explore categories like Citrus, Berries, Seasonal, and Imported to find what you love.</p>
        </div>
        <div class="card">
            <h3>2. Add to Cart</h3>
            <p>Choose the quantity you need and add items to your cart. See your live total instantly.</p>
        </div>
        <div class="card">
            <h3>3. Get it Delivered</h3>
            <p>Confirm your address and place order. Sit back and relax while we deliver to your doorstep.</p>
        </div>
    </div>
</section>

<?php include "../includes/footer.php"; ?>
