<?php
require_once "../config/db.php";
require_once "../includes/auth.php";
requireUserLogin();

$user_id = $_SESSION['user_id'];

$sql = "SELECT * FROM orders WHERE user_id = ? ORDER BY created_at DESC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$orders = $stmt->get_result();

include "../includes/header.php";
?>
<div class="table-card">
    <h2>My Orders</h2>
    <table class="table">
        <thead>
            <tr>
                <th>Order #</th>
                <th>Date & Time</th>
                <th>Total Amount</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($order = $orders->fetch_assoc()): ?>
                <tr>
                    <td><a href="order_details.php?id=<?php echo $order['id']; ?>">#<?php echo $order['id']; ?></a></td>
                    <td><?php echo $order['created_at']; ?></td>
                    <td>₹<?php echo number_format($order['total_amount'], 2); ?></td>
                    <td><?php echo htmlspecialchars($order['status']); ?></td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
<?php include "../includes/footer.php"; ?>
