<?php
require_once "../config/db.php";
include "header.php";

// Stats
$users = $conn->query("SELECT COUNT(*) AS c FROM users")->fetch_assoc()['c'] ?? 0;
$fruits = $conn->query("SELECT COUNT(*) AS c FROM fruits")->fetch_assoc()['c'] ?? 0;
$orders = $conn->query("SELECT COUNT(*) AS c FROM orders")->fetch_assoc()['c'] ?? 0;
$pending = $conn->query("SELECT COUNT(*) AS c FROM orders WHERE status = 'Pending'")->fetch_assoc()['c'] ?? 0;
?>
<div class="stats-grid">
    <div class="stat-card">
        <h4>Registered Users</h4>
        <p><?php echo $users; ?></p>
    </div>
    <div class="stat-card">
        <h4>Fruits Available</h4>
        <p><?php echo $fruits; ?></p>
    </div>
    <div class="stat-card">
        <h4>Total Orders</h4>
        <p><?php echo $orders; ?></p>
    </div>
    <div class="stat-card">
        <h4>Pending Orders</h4>
        <p><?php echo $pending; ?></p>
    </div>
</div>
<div class="table-card">
    <h2>Recent Orders</h2>
    <table class="table">
        <thead>
            <tr>
                <th>#</th>
                <th>Customer</th>
                <th>Total</th>
                <th>Status</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
        <?php
        $sql = "SELECT o.*, u.name FROM orders o 
                LEFT JOIN users u ON o.user_id = u.id 
                ORDER BY o.created_at DESC LIMIT 10";
        $res = $conn->query($sql);
        while ($row = $res->fetch_assoc()):
        ?>
            <tr>
                <td>#<?php echo $row['id']; ?></td>
                <td><?php echo htmlspecialchars($row['name']); ?></td>
                <td>₹<?php echo number_format($row['total_amount'], 2); ?></td>
                <td><?php echo htmlspecialchars($row['status']); ?></td>
                <td><?php echo $row['created_at']; ?></td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
</div>
<?php include "footer.php"; ?>
