<?php
require_once "../config/db.php";
include "header.php";

$statusFilter = $_GET['status'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['order_id'], $_POST['status'])) {
    $order_id = (int)$_POST['order_id'];
    $status = $_POST['status'];
    $stmt = $conn->prepare("UPDATE orders SET status = ? WHERE id = ?");
    $stmt->bind_param("si", $status, $order_id);
    $stmt->execute();
}

$sql = "SELECT o.*, u.name, u.mobile FROM orders o 
        LEFT JOIN users u ON o.user_id = u.id WHERE 1=1";
if ($statusFilter !== '' && $statusFilter !== 'all') {
    $sql .= " AND o.status = '" . $conn->real_escape_string($statusFilter) . "'";
}
$sql .= " ORDER BY o.created_at DESC";
$orders = $conn->query($sql);
?>
<div class="table-card">
    <h2>Orders</h2>
    <form method="get" style="margin-bottom:12px;">
        <label>Filter by status:</label>
        <select name="status" onchange="this.form.submit()">
            <option value="all">All</option>
            <?php
            $statuses = ['Pending','Packed','Out for Delivery','Delivered','Cancelled'];
            foreach ($statuses as $st):
            ?>
                <option value="<?php echo $st; ?>" <?php if($statusFilter === $st) echo 'selected'; ?>><?php echo $st; ?></option>
            <?php endforeach; ?>
        </select>
    </form>
    <table class="table">
        <thead>
            <tr>
                <th>#</th>
                <th>Customer</th>
                <th>Contact</th>
                <th>Total</th>
                <th>Status</th>
                <th>Placed At</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php while ($o = $orders->fetch_assoc()): ?>
                <tr>
                    <td>#<?php echo $o['id']; ?></td>
                    <td><?php echo htmlspecialchars($o['name']); ?></td>
                    <td><?php echo htmlspecialchars($o['mobile']); ?></td>
                    <td>₹<?php echo number_format($o['total_amount'], 2); ?></td>
                    <td><?php echo htmlspecialchars($o['status']); ?></td>
                    <td><?php echo $o['created_at']; ?></td>
                    <td>
                        <form method="post" style="display:flex; gap:4px;">
                            <input type="hidden" name="order_id" value="<?php echo $o['id']; ?>">
                            <select name="status">
                                <?php foreach ($statuses as $st): ?>
                                    <option value="<?php echo $st; ?>" <?php if($o['status'] === $st) echo 'selected'; ?>>
                                        <?php echo $st; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <button type="submit" class="btn">Update</button>
                        </form>
                    </td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
<?php include "footer.php"; ?>
