<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

function addToCart($fruit_id, $name, $price) {
    if (!isset($_SESSION['cart'][$fruit_id])) {
        $_SESSION['cart'][$fruit_id] = [
            'name' => $name,
            'price' => $price,
            'qty' => 1
        ];
    } else {
        $_SESSION['cart'][$fruit_id]['qty'] += 1;
    }
}

function updateCartQuantity($fruit_id, $qty) {
    if (isset($_SESSION['cart'][$fruit_id])) {
        if ($qty <= 0) {
            unset($_SESSION['cart'][$fruit_id]);
        } else {
            $_SESSION['cart'][$fruit_id]['qty'] = $qty;
        }
    }
}

function removeFromCart($fruit_id) {
    if (isset($_SESSION['cart'][$fruit_id])) {
        unset($_SESSION['cart'][$fruit_id]);
    }
}

function getCartTotal() {
    $total = 0;
    foreach ($_SESSION['cart'] as $item) {
        $total += $item['price'] * $item['qty'];
    }
    return $total;
}
?>
