<?php
require_once "../config/db.php";
require_once "../includes/auth.php";
require_once "../includes/cart_functions.php";
requireUserLogin();

$user_id = $_SESSION['user_id'];
$message = "";

if (empty($_SESSION['cart'])) {
    header("Location: cart.php");
    exit;
}

// fetch user address
$stmt = $conn->prepare("SELECT address FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($address);
$stmt->fetch();
$stmt->close();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $delivery_address = trim($_POST['address'] ?? $address);
    $total = getCartTotal();
    $status = 'Pending';

    $stmt = $conn->prepare("INSERT INTO orders (user_id, delivery_address, total_amount, status) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("isds", $user_id, $delivery_address, $total, $status);
    if ($stmt->execute()) {
        $order_id = $stmt->insert_id;
        $stmt->close();

        // insert order items
        $itemStmt = $conn->prepare("INSERT INTO order_items (order_id, fruit_id, quantity, unit_price) VALUES (?, ?, ?, ?)");
        foreach ($_SESSION['cart'] as $fruit_id => $item) {
            $qty = $item['qty'];
            $price = $item['price'];
            $itemStmt->bind_param("iiid", $order_id, $fruit_id, $qty, $price);
            $itemStmt->execute();

            // reduce stock
            $upd = $conn->prepare("UPDATE fruits SET stock_quantity = stock_quantity - ? WHERE id = ?");
            $upd->bind_param("ii", $qty, $fruit_id);
            $upd->execute();
        }
        $itemStmt->close();

        $_SESSION['cart'] = [];
        $message = "Order placed successfully.";
    } else {
        $message = "Error placing order.";
    }
}

include "../includes/header.php";
?>
<div class="table-card">
    <h2>Checkout</h2>
    <?php if($message): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
        <p><a href="orders.php" class="btn">View My Orders</a></p>
    <?php else: ?>
        <form method="post">
            <div class="form-group">
                <label>Delivery Address</label>
                <textarea name="address" rows="4"><?php echo htmlspecialchars($address); ?></textarea>
            </div>
            <h3>Order Summary</h3>
            <table class="table">
                <thead>
                    <tr>
                        <th>Fruit</th>
                        <th>Unit Price</th>
                        <th>Qty</th>
                        <th>Subtotal</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach($_SESSION['cart'] as $item): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($item['name']); ?></td>
                        <td>₹<?php echo number_format($item['price'], 2); ?></td>
                        <td><?php echo (int)$item['qty']; ?></td>
                        <td>₹<?php echo number_format($item['price'] * $item['qty'], 2); ?></td>
                    </tr>
                <?php endforeach; ?>
                <tr>
                    <td colspan="3" style="text-align:right;"><strong>Total:</strong></td>
                    <td><strong>₹<?php echo number_format(getCartTotal(), 2); ?></strong></td>
                </tr>
                </tbody>
            </table>
            <div class="form-actions">
                <button type="submit" class="btn">Confirm Order (COD)</button>
            </div>
        </form>
    <?php endif; ?>
</div>
<?php include "../includes/footer.php"; ?>
