<?php
require_once "../config/db.php";
require_once "../includes/auth.php";
requireUserLogin();

$user_id = $_SESSION['user_id'];
$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update_profile'])) {
        $name = trim($_POST['name'] ?? '');
        $mobile = trim($_POST['mobile'] ?? '');
        $address = trim($_POST['address'] ?? '');

        $stmt = $conn->prepare("UPDATE users SET name = ?, mobile = ?, address = ? WHERE id = ?");
        $stmt->bind_param("sssi", $name, $mobile, $address, $user_id);
        if ($stmt->execute()) {
            $message = "Profile updated successfully.";
        } else {
            $message = "Error updating profile.";
        }
    } elseif (isset($_POST['change_password'])) {
        $old = $_POST['old_password'] ?? '';
        $new = $_POST['new_password'] ?? '';
        $confirm = $_POST['confirm_password'] ?? '';

        if ($new !== $confirm) {
            $message = "New passwords do not match.";
        } else {
            $stmt = $conn->prepare("SELECT password_hash FROM users WHERE id = ?");
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $stmt->bind_result($hash);
            if ($stmt->fetch() && password_verify($old, $hash)) {
                $stmt->close();
                $newHash = password_hash($new, PASSWORD_BCRYPT);
                $stmt = $conn->prepare("UPDATE users SET password_hash = ? WHERE id = ?");
                $stmt->bind_param("si", $newHash, $user_id);
                if ($stmt->execute()) {
                    $message = "Password changed successfully.";
                } else {
                    $message = "Error changing password.";
                }
            } else {
                $message = "Old password is incorrect.";
            }
        }
    }
}

// fetch user
$stmt = $conn->prepare("SELECT name, email, mobile, address FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

include "../includes/header.php";
?>
<div class="table-card">
    <h2>My Profile</h2>
    <?php if($message): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>
    <form method="post" style="display:grid; grid-template-columns:1.5fr 1fr; gap:24px;">
        <div>
            <h3>Profile Details</h3>
            <div class="form-group">
                <label>Name</label>
                <input type="text" name="name" value="<?php echo htmlspecialchars($user['name']); ?>"/>
            </div>
            <div class="form-group">
                <label>Email (read-only)</label>
                <input type="email" value="<?php echo htmlspecialchars($user['email']); ?>" readonly/>
            </div>
            <div class="form-group">
                <label>Mobile</label>
                <input type="text" name="mobile" value="<?php echo htmlspecialchars($user['mobile']); ?>"/>
            </div>
            <div class="form-group">
                <label>Default Delivery Address</label>
                <textarea name="address" rows="3"><?php echo htmlspecialchars($user['address']); ?></textarea>
            </div>
            <button type="submit" name="update_profile" class="btn">Save Profile</button>
        </div>
        <div>
            <h3>Change Password</h3>
            <div class="form-group">
                <label>Old Password</label>
                <input type="password" name="old_password"/>
            </div>
            <div class="form-group">
                <label>New Password</label>
                <input type="password" name="new_password"/>
            </div>
            <div class="form-group">
                <label>Confirm New Password</label>
                <input type="password" name="confirm_password"/>
            </div>
            <button type="submit" name="change_password" class="btn">Update Password</button>
        </div>
    </form>
</div>
<?php include "../includes/footer.php"; ?>
