<?php
require_once "../config/db.php";
require_once "../includes/auth.php";

$message = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $mobile = trim($_POST['mobile'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm = $_POST['confirm_password'] ?? '';

    if ($password !== $confirm) {
        $message = "Passwords do not match.";
    } else {
        // Check unique email
        $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows > 0) {
            $message = "Email already registered.";
        } else {
            $hash = password_hash($password, PASSWORD_BCRYPT);
            $status = 1;
            $stmt = $conn->prepare("INSERT INTO users (name, email, mobile, password_hash, status) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("ssssi", $name, $email, $mobile, $hash, $status);
            if ($stmt->execute()) {
                $message = "Registration successful. Please login.";
            } else {
                $message = "Error: " . $conn->error;
            }
        }
    }
}
include "../includes/header.php";
?>
<div class="form-card">
    <h2>Create Account</h2>
    <?php if($message): ?>
        <div class="alert alert-error"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>
    <form method="post" action="">
        <div class="form-group">
            <label>Name</label>
            <input type="text" name="name" required/>
        </div>
        <div class="form-group">
            <label>Email</label>
            <input type="email" name="email" required/>
        </div>
        <div class="form-group">
            <label>Mobile</label>
            <input type="text" name="mobile" required/>
        </div>
        <div class="form-group">
            <label>Password</label>
            <input type="password" name="password" required/>
        </div>
        <div class="form-group">
            <label>Confirm password</label>
            <input type="password" name="confirm_password" required/>
        </div>
        <div class="form-actions">
            <button type="submit" class="btn">Register</button>
        </div>
    </form>
</div>
<?php include "../includes/footer.php"; ?>
